export const FacebookIcon = ( props ) => (
	<svg
		width="48"
		height="48"
		viewBox="0 0 48 48"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_7896_51189)">
			<path
				d="M48 24C48 10.7453 37.2547 0 24 0C10.7453 0 0 10.7453 0 24C0 35.255 7.74912 44.6995 18.2026 47.2934V31.3344H13.2538V24H18.2026V20.8397C18.2026 12.671 21.8995 8.8848 29.9194 8.8848C31.44 8.8848 34.0637 9.18336 35.137 9.48096V16.129C34.5706 16.0694 33.5866 16.0397 32.3645 16.0397C28.4294 16.0397 26.9088 17.5306 26.9088 21.4061V24H34.7482L33.4013 31.3344H26.9088V47.8243C38.7926 46.3891 48.001 36.2707 48.001 24H48Z"
				fill="#0866FF"
			/>
			<path
				d="M33.4005 31.3344L34.7473 24H26.908V21.4061C26.908 17.5306 28.4286 16.0397 32.3636 16.0397C33.5857 16.0397 34.5697 16.0695 35.1361 16.129V9.48099C34.0628 9.18243 31.4392 8.88483 29.9185 8.88483C21.8987 8.88483 18.2017 12.6711 18.2017 20.8397V24H13.2529V31.3344H18.2017V47.2935C20.0584 47.7543 22.0005 48 23.9992 48C24.9832 48 25.9537 47.9395 26.907 47.8243V31.3344H33.3995H33.4005Z"
				fill="white"
			/>
		</g>
		<defs>
			<clipPath id="clip0_7896_51189">
				<rect width="48" height="48" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const TwitterIcon = ( props ) => (
	<svg
		width="48"
		height="48"
		viewBox="0 0 48 48"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M36.6526 3.8078H43.3995L28.6594 20.6548L46 43.5797H32.4225L21.7881 29.6759L9.61989 43.5797H2.86886L18.6349 25.56L2 3.8078H15.9222L25.5348 16.5165L36.6526 3.8078ZM34.2846 39.5414H38.0232L13.8908 7.63406H9.87892L34.2846 39.5414Z"
			fill="black"
		/>
	</svg>
);

export const InstagramIcon = ( props ) => (
	<svg
		width="48"
		height="48"
		viewBox="0 0 48 48"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_7896_51183)">
			<path
				d="M24 4.32187C30.4125 4.32187 31.1719 4.35 33.6938 4.4625C36.0375 4.56562 37.3031 4.95938 38.1469 5.2875C39.2625 5.71875 40.0688 6.24375 40.9031 7.07812C41.7469 7.92188 42.2625 8.71875 42.6938 9.83438C43.0219 10.6781 43.4156 11.9531 43.5188 14.2875C43.6313 16.8187 43.6594 17.5781 43.6594 23.9813C43.6594 30.3938 43.6313 31.1531 43.5188 33.675C43.4156 36.0188 43.0219 37.2844 42.6938 38.1281C42.2625 39.2438 41.7375 40.05 40.9031 40.8844C40.0594 41.7281 39.2625 42.2438 38.1469 42.675C37.3031 43.0031 36.0281 43.3969 33.6938 43.5C31.1625 43.6125 30.4031 43.6406 24 43.6406C17.5875 43.6406 16.8281 43.6125 14.3063 43.5C11.9625 43.3969 10.6969 43.0031 9.85313 42.675C8.7375 42.2438 7.93125 41.7188 7.09688 40.8844C6.25313 40.0406 5.7375 39.2438 5.30625 38.1281C4.97813 37.2844 4.58438 36.0094 4.48125 33.675C4.36875 31.1438 4.34063 30.3844 4.34063 23.9813C4.34063 17.5688 4.36875 16.8094 4.48125 14.2875C4.58438 11.9437 4.97813 10.6781 5.30625 9.83438C5.7375 8.71875 6.2625 7.9125 7.09688 7.07812C7.94063 6.23438 8.7375 5.71875 9.85313 5.2875C10.6969 4.95938 11.9719 4.56562 14.3063 4.4625C16.8281 4.35 17.5875 4.32187 24 4.32187ZM24 0C17.4844 0 16.6688 0.028125 14.1094 0.140625C11.5594 0.253125 9.80625 0.665625 8.2875 1.25625C6.70312 1.875 5.3625 2.69062 4.03125 4.03125C2.69063 5.3625 1.875 6.70313 1.25625 8.27813C0.665625 9.80625 0.253125 11.55 0.140625 14.1C0.028125 16.6687 0 17.4844 0 24C0 30.5156 0.028125 31.3312 0.140625 33.8906C0.253125 36.4406 0.665625 38.1938 1.25625 39.7125C1.875 41.2969 2.69063 42.6375 4.03125 43.9688C5.3625 45.3 6.70313 46.125 8.27813 46.7344C9.80625 47.325 11.55 47.7375 14.1 47.85C16.6594 47.9625 17.475 47.9906 23.9906 47.9906C30.5063 47.9906 31.3219 47.9625 33.8813 47.85C36.4313 47.7375 38.1844 47.325 39.7031 46.7344C41.2781 46.125 42.6188 45.3 43.95 43.9688C45.2812 42.6375 46.1063 41.2969 46.7156 39.7219C47.3063 38.1938 47.7188 36.45 47.8313 33.9C47.9438 31.3406 47.9719 30.525 47.9719 24.0094C47.9719 17.4938 47.9438 16.6781 47.8313 14.1188C47.7188 11.5688 47.3063 9.81563 46.7156 8.29688C46.125 6.70312 45.3094 5.3625 43.9688 4.03125C42.6375 2.7 41.2969 1.875 39.7219 1.26562C38.1938 0.675 36.45 0.2625 33.9 0.15C31.3313 0.028125 30.5156 0 24 0Z"
				fill="#000100"
			/>
			<path
				d="M24 11.6719C17.1938 11.6719 11.6719 17.1938 11.6719 24C11.6719 30.8062 17.1938 36.3281 24 36.3281C30.8062 36.3281 36.3281 30.8062 36.3281 24C36.3281 17.1938 30.8062 11.6719 24 11.6719ZM24 31.9969C19.5844 31.9969 16.0031 28.4156 16.0031 24C16.0031 19.5844 19.5844 16.0031 24 16.0031C28.4156 16.0031 31.9969 19.5844 31.9969 24C31.9969 28.4156 28.4156 31.9969 24 31.9969Z"
				fill="#000100"
			/>
			<path
				d="M39.6937 11.1844C39.6937 12.7782 38.4 14.0625 36.8156 14.0625C35.2219 14.0625 33.9375 12.7688 33.9375 11.1844C33.9375 9.59065 35.2313 8.30627 36.8156 8.30627C38.4 8.30627 39.6937 9.60003 39.6937 11.1844Z"
				fill="#000100"
			/>
		</g>
		<defs>
			<clipPath id="clip0_7896_51183">
				<rect width="48" height="48" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const LinkedInIcon = ( props ) => (
	<svg
		width="48"
		height="48"
		viewBox="0 0 48 48"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_7896_51181)">
			<path
				d="M44.4567 0H3.54333C2.60358 0 1.70232 0.373315 1.03782 1.03782C0.373315 1.70232 0 2.60358 0 3.54333V44.4567C0 45.3964 0.373315 46.2977 1.03782 46.9622C1.70232 47.6267 2.60358 48 3.54333 48H44.4567C45.3964 48 46.2977 47.6267 46.9622 46.9622C47.6267 46.2977 48 45.3964 48 44.4567V3.54333C48 2.60358 47.6267 1.70232 46.9622 1.03782C46.2977 0.373315 45.3964 0 44.4567 0ZM14.3067 40.89H7.09V17.9667H14.3067V40.89ZM10.6933 14.79C9.87473 14.7854 9.07583 14.5384 8.39747 14.0802C7.71911 13.622 7.19168 12.9731 6.88175 12.2154C6.57183 11.4577 6.4933 10.6252 6.65606 9.82291C6.81883 9.02063 7.2156 8.28455 7.79631 7.70756C8.37702 7.13057 9.11563 6.73853 9.91893 6.58092C10.7222 6.42331 11.5542 6.50719 12.3099 6.82197C13.0656 7.13675 13.7111 7.66833 14.1649 8.34962C14.6188 9.03092 14.8606 9.83138 14.86 10.65C14.8677 11.1981 14.765 11.7421 14.558 12.2496C14.351 12.7571 14.044 13.2178 13.6551 13.6041C13.2663 13.9905 12.8037 14.2946 12.2948 14.4983C11.786 14.702 11.2413 14.8012 10.6933 14.79ZM40.9067 40.91H33.6933V28.3867C33.6933 24.6933 32.1233 23.5533 30.0967 23.5533C27.9567 23.5533 25.8567 25.1667 25.8567 28.48V40.91H18.64V17.9833H25.58V21.16H25.6733C26.37 19.75 28.81 17.34 32.5333 17.34C36.56 17.34 40.91 19.73 40.91 26.73L40.9067 40.91Z"
				fill="#0A66C2"
			/>
		</g>
		<defs>
			<clipPath id="clip0_7896_51181">
				<rect width="48" height="48" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const YouTubeIcon = ( props ) => (
	<svg
		width="48"
		height="48"
		viewBox="0 0 48 48"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_7896_51172)">
			<path
				d="M47.0442 12.3709C46.7728 11.3498 46.238 10.4178 45.4933 9.66825C44.7485 8.91872 43.82 8.37794 42.8006 8.10003C39.0479 7.09094 24.0479 7.09094 24.0479 7.09094C24.0479 7.09094 9.04785 7.09094 5.29512 8.10003C4.27571 8.37794 3.34717 8.91872 2.60243 9.66825C1.85768 10.4178 1.32286 11.3498 1.05149 12.3709C0.0478517 16.14 0.0478516 24 0.0478516 24C0.0478516 24 0.0478517 31.86 1.05149 35.6291C1.32286 36.6503 1.85768 37.5823 2.60243 38.3318C3.34717 39.0813 4.27571 39.6221 5.29512 39.9C9.04785 40.9091 24.0479 40.9091 24.0479 40.9091C24.0479 40.9091 39.0479 40.9091 42.8006 39.9C43.82 39.6221 44.7485 39.0813 45.4933 38.3318C46.238 37.5823 46.7728 36.6503 47.0442 35.6291C48.0479 31.86 48.0479 24 48.0479 24C48.0479 24 48.0479 16.14 47.0442 12.3709Z"
				fill="#FF0302"
			/>
			<path
				d="M19.1387 31.1373V16.8628L31.6841 24.0001L19.1387 31.1373Z"
				fill="#FEFEFE"
			/>
		</g>
		<defs>
			<clipPath id="clip0_7896_51172">
				<rect width="48" height="48" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const PinterestIcon = ( props ) => (
	<svg
		width="48"
		height="48"
		viewBox="0 0 48 48"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_7896_51164)">
			<path
				d="M24 48C37.2548 48 48 37.2548 48 24C48 10.7452 37.2548 0 24 0C10.7452 0 0 10.7452 0 24C0 37.2548 10.7452 48 24 48Z"
				fill="white"
			/>
			<path
				d="M24 0C10.7457 0 0 10.7457 0 24C0 34.1728 6.32099 42.8642 15.2494 46.3605C15.0321 44.4642 14.8543 41.5407 15.3284 39.4667C15.763 37.5901 18.1333 27.5358 18.1333 27.5358C18.1333 27.5358 17.4222 26.0938 17.4222 23.9802C17.4222 20.642 19.358 18.1531 21.7679 18.1531C23.8222 18.1531 24.8099 19.6938 24.8099 21.5309C24.8099 23.5852 23.5062 26.6667 22.8148 29.5309C22.242 31.921 24.0198 33.8765 26.3704 33.8765C30.637 33.8765 33.916 29.3728 33.916 22.8938C33.916 17.1457 29.7877 13.1358 23.8815 13.1358C17.0469 13.1358 13.037 18.2519 13.037 23.5457C13.037 25.6 13.8272 27.8123 14.8148 29.0173C15.0123 29.2543 15.0321 29.4716 14.9728 29.7086C14.7951 30.4593 14.3802 32.0988 14.3012 32.4346C14.2025 32.8691 13.9457 32.9679 13.4914 32.7506C10.4889 31.3481 8.61235 26.9827 8.61235 23.4469C8.61235 15.8815 14.1037 8.9284 24.4741 8.9284C32.7901 8.9284 39.2691 14.8543 39.2691 22.7951C39.2691 31.0716 34.0543 37.7284 26.8247 37.7284C24.3951 37.7284 22.1037 36.4642 21.3333 34.963C21.3333 34.963 20.1284 39.5457 19.8321 40.6716C19.2988 42.7654 17.837 45.3728 16.8494 46.9728C19.1012 47.6642 21.4716 48.0395 23.9605 48.0395C37.2148 48.0395 47.9605 37.2938 47.9605 24.0395C48 10.7457 37.2543 0 24 0Z"
				fill="#E60019"
			/>
		</g>
		<defs>
			<clipPath id="clip0_7896_51164">
				<rect width="48" height="48" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const MediumIcon = ( props ) => (
	<svg
		width="48"
		height="48"
		viewBox="0 0 48 48"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M48 23.6554C48 30.0141 46.9344 35.1719 45.6194 35.1719C44.3045 35.1719 43.2393 30.0154 43.2393 23.6554C43.2393 17.2954 44.3049 12.1389 45.6194 12.1389C46.9339 12.1389 48 17.2949 48 23.6554Z"
			fill="black"
		/>
		<path
			d="M41.9254 23.6554C41.9254 30.7541 38.8949 36.5109 35.1565 36.5109C31.4182 36.5109 28.3877 30.7541 28.3877 23.6554C28.3877 16.5568 31.4177 10.7999 35.1561 10.7999C38.8944 10.7999 41.9249 16.555 41.9249 23.6554"
			fill="black"
		/>
		<path
			d="M27.0749 23.6554C27.0749 31.1968 21.0139 37.3103 13.5377 37.3103C6.06146 37.3103 0 31.1955 0 23.6554C0 16.1153 6.061 10 13.5377 10C21.0143 10 27.0749 16.114 27.0749 23.6554Z"
			fill="black"
		/>
	</svg>
);

export const GitHubIcon = ( props ) => (
	<svg
		width="48"
		height="48"
		viewBox="0 0 48 48"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_7896_51158)">
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M24.0199 0C10.7375 0 0 10.8167 0 24.1983C0 34.895 6.87988 43.9495 16.4241 47.1542C17.6174 47.3951 18.0545 46.6335 18.0545 45.9929C18.0545 45.4319 18.0151 43.509 18.0151 41.5055C11.3334 42.948 9.94198 38.6209 9.94198 38.6209C8.86818 35.8164 7.27715 35.0956 7.27715 35.0956C5.09022 33.6132 7.43645 33.6132 7.43645 33.6132C9.86233 33.7735 11.1353 36.0971 11.1353 36.0971C13.2824 39.7827 16.7422 38.7413 18.1341 38.1002C18.3328 36.5377 18.9695 35.456 19.6455 34.8552C14.3163 34.2942 8.70937 32.211 8.70937 22.9161C8.70937 20.2719 9.66321 18.1086 11.1746 16.4261C10.9361 15.8253 10.1008 13.3409 11.4135 10.0157C11.4135 10.0157 13.4417 9.3746 18.0146 12.4996C19.9725 11.9699 21.9916 11.7005 24.0199 11.6982C26.048 11.6982 28.1154 11.979 30.0246 12.4996C34.5981 9.3746 36.6262 10.0157 36.6262 10.0157C37.9389 13.3409 37.1031 15.8253 36.8646 16.4261C38.4158 18.1086 39.3303 20.2719 39.3303 22.9161C39.3303 32.211 33.7234 34.2539 28.3544 34.8552C29.2296 35.6163 29.9848 37.0583 29.9848 39.3421C29.9848 42.5871 29.9454 45.1915 29.9454 45.9924C29.9454 46.6335 30.383 47.3951 31.5758 47.1547C41.12 43.9491 47.9999 34.895 47.9999 24.1983C48.0392 10.8167 37.2624 0 24.0199 0Z"
				fill="#24292F"
			/>
		</g>
		<defs>
			<clipPath id="clip0_7896_51158">
				<rect width="48" height="48" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const ThreadsIcon = ( props ) => (
	<svg
		width="48"
		height="48"
		viewBox="0 0 48 48"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M35.3843 22.2471C35.1775 22.148 34.9675 22.0526 34.7547 21.9613C34.3842 15.1346 30.654 11.2262 24.3905 11.1862C24.3621 11.1861 24.3339 11.1861 24.3055 11.1861C20.5591 11.1861 17.4433 12.7852 15.5255 15.6952L18.9702 18.0582C20.4029 15.8846 22.6513 15.4212 24.3071 15.4212C24.3263 15.4212 24.3455 15.4212 24.3644 15.4214C26.4268 15.4345 27.983 16.0342 28.9902 17.2035C29.7232 18.0548 30.2135 19.2313 30.4562 20.716C28.6277 20.4052 26.6502 20.3096 24.5362 20.4308C18.5812 20.7738 14.7528 24.247 15.0099 29.073C15.1404 31.521 16.3599 33.627 18.4438 35.0028C20.2056 36.1657 22.4748 36.7345 24.8331 36.6058C27.9475 36.435 30.3907 35.2467 32.0952 33.074C33.3897 31.424 34.2085 29.2857 34.57 26.5915C36.0542 27.4872 37.1543 28.666 37.7617 30.083C38.7948 32.4917 38.855 36.45 35.6253 39.677C32.7955 42.504 29.394 43.727 24.2534 43.7648C18.551 43.7225 14.2384 41.8937 11.4345 38.3293C8.80887 34.9915 7.45192 30.1705 7.4013 24C7.45192 17.8295 8.80887 13.0084 11.4345 9.67068C14.2384 6.10623 18.551 4.2775 24.2533 4.23513C29.997 4.27782 34.3848 6.11535 37.296 9.697C38.7235 11.4534 39.7998 13.6622 40.5093 16.2376L44.546 15.1606C43.686 11.9906 42.3327 9.25893 40.4912 6.9935C36.759 2.40167 31.3005 0.048787 24.2674 0H24.2392C17.2204 0.0486175 11.823 2.41045 8.19707 7.01982C4.97047 11.1216 3.3061 16.8289 3.25017 23.9831L3.25 24L3.25017 24.0169C3.3061 31.171 4.97047 36.8785 8.19707 40.9803C11.823 45.5895 17.2204 47.9515 24.2392 48H24.2674C30.5075 47.9567 34.906 46.323 38.5295 42.7028C43.2702 37.9665 43.1275 32.0298 41.565 28.3853C40.444 25.7717 38.3068 23.649 35.3843 22.2471ZM24.6101 32.3768C22.0001 32.5238 19.2886 31.3523 19.1549 28.843C19.0558 26.9825 20.479 24.9065 24.7703 24.6592C25.2617 24.6308 25.744 24.617 26.2178 24.617C27.7765 24.617 29.2347 24.7684 30.5605 25.0583C30.066 31.2337 27.1655 32.2365 24.6101 32.3768Z"
			fill="black"
		/>
	</svg>
);

export const TikTokIcon = ( props ) => (
	<svg
		width="48"
		height="48"
		viewBox="0 0 48 48"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M34.3529 17.3269C37.4396 19.5413 41.221 20.8442 45.305 20.8442V12.9572C44.5321 12.9574 43.7612 12.8765 43.005 12.7157V18.9239C38.9213 18.9239 35.1404 17.621 32.0529 15.4068V31.5017C32.0529 39.5533 25.5491 46.0798 17.5267 46.0798C14.5333 46.0798 11.7511 45.1716 9.43994 43.6141C12.0778 46.3208 15.7564 48 19.8262 48C27.8491 48 34.3533 41.4734 34.3533 33.4215V17.3269H34.3529ZM37.1902 9.36999C35.6128 7.64045 34.577 5.40535 34.3529 2.93435V1.91992H32.1733C32.722 5.06056 34.5933 7.74374 37.1902 9.36999ZM14.5141 37.4356C13.6328 36.2759 13.1565 34.8572 13.1586 33.3985C13.1586 29.716 16.1334 26.7302 19.8035 26.7302C20.4875 26.7301 21.1674 26.8352 21.8192 27.0427V18.9795C21.0575 18.8748 20.2887 18.8303 19.5202 18.8466V25.1226C18.8679 24.915 18.1877 24.8096 17.5035 24.8103C13.8334 24.8103 10.8588 27.7957 10.8588 31.4787C10.8588 34.0828 12.3457 36.3373 14.5141 37.4356Z"
			fill="#FF004F"
		/>
		<path
			d="M32.0529 15.4066C35.1404 17.6208 38.9213 18.9237 43.005 18.9237V12.7156C40.7255 12.2283 38.7075 11.0328 37.1903 9.36999C34.5931 7.74358 32.722 5.0604 32.1733 1.91992H26.4482V33.4212C26.4352 37.0936 23.4655 40.0672 19.8032 40.0672C17.6451 40.0672 15.7279 39.0348 14.5136 37.4356C12.3454 36.3373 10.8585 34.0826 10.8585 31.4788C10.8585 27.7962 13.8331 24.8104 17.5032 24.8104C18.2064 24.8104 18.8842 24.9203 19.5199 25.1228V18.8468C11.6384 19.0102 5.2998 25.473 5.2998 33.4214C5.2998 37.3892 6.87827 40.9861 9.44013 43.6143C11.7513 45.1716 14.5335 46.08 17.5268 46.08C25.5494 46.08 32.0531 39.5531 32.0531 31.5017V15.4066H32.0529Z"
			fill="black"
		/>
		<path
			d="M43.0051 12.7156V11.037C40.9495 11.0401 38.9343 10.4624 37.1903 9.36987C38.7342 11.0661 40.7671 12.2357 43.0051 12.7156ZM32.1734 1.91997C32.1211 1.61982 32.0809 1.3177 32.053 1.01443V0H24.148V31.5016C24.1354 35.1735 21.1658 38.1471 17.5033 38.1471C16.428 38.1471 15.4128 37.891 14.5137 37.4358C15.7279 39.0349 17.6452 40.0671 19.8033 40.0671C23.4652 40.0671 26.4354 37.0938 26.4482 33.4214V1.91997H32.1734ZM19.5203 18.8468V17.0598C18.8598 16.9692 18.1938 16.9237 17.5271 16.924C9.50383 16.9239 3 23.4508 3 31.5016C3 36.5491 5.55612 40.9974 9.44034 43.614C6.87848 40.986 5.30002 37.3889 5.30002 33.4213C5.30002 25.473 11.6385 19.0102 19.5203 18.8468Z"
			fill="#00F2EA"
		/>
	</svg>
);

export const TumblrIcon = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M14.563 24C9.47 24 7.532 20.244 7.532 17.589V9.747H5.116V6.648C8.746 5.335 9.628 2.052 9.826 0.179C9.84 0.051 9.941 0 9.999 0H13.516V6.114H18.317V9.747H13.497V17.217C13.513 18.218 13.872 19.588 15.704 19.588H15.794C16.425 19.568 17.28 19.383 17.73 19.169L18.886 22.594C18.45 23.23 16.486 23.968 14.73 23.998H14.552L14.563 24Z"
			fill="#36465D"
		/>
	</svg>
);

export const YelpIcon = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_1_8)">
			<path
				d="M7.6885 15.1415L4.017 15.9898C3.6401 16.0769 3.262 16.1728 2.8718 16.1448C2.6107 16.126 2.3596 16.1034 2.1112 15.9318C1.97698 15.8364 1.86423 15.714 1.7802 15.5724C1.4316 15.0205 1.4146 14.2063 1.4105 13.572C1.405 12.8703 1.51701 12.1725 1.7419 11.5078C1.77163 11.4228 1.80749 11.3402 1.8492 11.2604C1.88715 11.186 1.92904 11.1138 1.9747 11.0439C2.02339 10.9754 2.07556 10.9095 2.131 10.8464C2.24264 10.725 2.37859 10.6286 2.53 10.5633C2.67516 10.5023 2.83187 10.4738 2.9892 10.4796C3.2247 10.4812 3.5031 10.5316 3.8992 10.653C3.9547 10.6721 4.0229 10.6912 4.0848 10.7102C4.4125 10.8115 4.7896 10.9506 5.2347 11.1089C5.921 11.3493 6.601 11.5959 7.281 11.8486L8.4927 12.2909C8.7144 12.3716 8.929 12.4709 9.1339 12.5879C9.3079 12.6863 9.4612 12.8177 9.5851 12.9749C9.67659 13.1046 9.74182 13.251 9.7771 13.4058C9.84794 13.7136 9.79666 14.037 9.63404 14.3078C9.47142 14.5786 9.21013 14.7758 8.9051 14.858C8.8583 14.8731 8.8199 14.8819 8.7966 14.8873L7.6916 15.1426L7.6885 15.1415ZM18.8208 7.56499C18.7571 7.50165 18.6888 7.44303 18.6166 7.38959C18.5498 7.33956 18.4805 7.29303 18.4089 7.25019C18.3353 7.20985 18.2595 7.17347 18.182 7.14119C18.0287 7.08106 17.8645 7.05393 17.7 7.06159C17.5427 7.07057 17.3892 7.11367 17.2502 7.18789C17.0395 7.29269 16.8114 7.46109 16.5082 7.74299C16.4662 7.78469 16.4135 7.83159 16.3662 7.87599C16.116 8.11109 15.8376 8.4012 15.5063 8.739C14.9958 9.25515 14.4903 9.77614 13.9897 10.3019L13.0935 11.2312C12.9294 11.401 12.7801 11.5845 12.6469 11.7795C12.5334 11.9444 12.4531 12.1298 12.4105 12.3254C12.3859 12.4753 12.3895 12.6286 12.4212 12.7772L12.4258 12.7972C12.4965 13.1049 12.6839 13.3731 12.9485 13.5453C13.2131 13.7174 13.5343 13.7802 13.8442 13.7202C13.8814 13.7149 13.9182 13.7078 13.9547 13.6989L18.7328 12.5949C19.1094 12.5079 19.4915 12.4282 19.8298 12.2318C20.0567 12.1002 20.2726 11.9698 20.4207 11.7066C20.4997 11.562 20.5476 11.4025 20.5612 11.2383C20.6345 10.5871 20.2944 9.8475 20.0209 9.2753C19.7192 8.64218 19.3135 8.06407 18.8208 7.56499ZM8.9703 0.0753949C8.69126 0.114017 8.41426 0.166212 8.1403 0.231795C7.8649 0.297795 7.5923 0.370095 7.3257 0.455395C6.4577 0.739795 5.2373 1.26169 5.0307 2.26189C4.9142 2.82739 5.1902 3.40579 5.4044 3.92189C5.6639 4.54729 6.0184 5.11079 6.3417 5.69959C7.196 7.25409 8.0662 8.7989 8.9339 10.3453C9.1929 10.807 9.4755 11.3917 9.9769 11.6309C10.01 11.6454 10.0438 11.6582 10.0782 11.6692C10.303 11.7543 10.5481 11.7708 10.7823 11.7163C10.7963 11.7131 10.8102 11.7099 10.8241 11.7066C11.0405 11.6478 11.2363 11.5302 11.3899 11.3669C11.4176 11.3409 11.444 11.3134 11.4689 11.2847C11.8152 10.8497 11.8143 10.2014 11.8453 9.6713C11.9495 7.9003 12.0592 6.12899 12.1462 4.35709C12.1794 3.68589 12.2517 3.02379 12.2117 2.34749C12.1789 1.78959 12.1749 1.14909 11.8226 0.691195C11.2008 -0.116105 9.875 -0.0498051 8.9703 0.0753949ZM11.0543 16.0259C10.9192 15.8358 10.7273 15.6933 10.5063 15.6189C10.2852 15.5444 10.0463 15.5418 9.8237 15.6114C9.77137 15.6288 9.72037 15.6499 9.6711 15.6747C9.59496 15.7135 9.52233 15.7588 9.454 15.8101C9.2548 15.9576 9.0872 16.1493 8.9344 16.3416C8.8958 16.3906 8.8604 16.4559 8.8144 16.4978L8.0458 17.5551C7.6096 18.1472 7.17915 18.7436 6.7545 19.3441C6.4765 19.7336 6.2361 20.0625 6.0462 20.3535C6.0102 20.4082 5.9728 20.4695 5.9387 20.5182C5.711 20.8704 5.5821 21.1274 5.5159 21.3563C5.46624 21.5084 5.45054 21.6696 5.4699 21.8284C5.491 21.9939 5.5467 22.153 5.6334 22.2954C5.6794 22.3669 5.7291 22.436 5.7821 22.5024C5.83723 22.5664 5.89578 22.6273 5.9575 22.6849C6.02339 22.7478 6.09385 22.8056 6.1683 22.8581C6.6987 23.2271 7.2795 23.4923 7.8903 23.6972C8.39869 23.8659 8.92711 23.9669 9.4619 23.9976C9.5529 24.0022 9.644 24.0001 9.7347 23.9916C9.8188 23.9843 9.90245 23.9726 9.9853 23.9565C10.0681 23.9372 10.1498 23.9135 10.23 23.8855C10.3862 23.8271 10.5285 23.7365 10.6475 23.6197C10.7602 23.5067 10.8469 23.3707 10.9016 23.2208C10.9905 22.9994 11.0489 22.7182 11.0873 22.3008C11.0907 22.2415 11.0991 22.1703 11.105 22.105C11.1354 21.7587 11.1493 21.3519 11.1716 20.8735C11.2091 20.1378 11.2386 19.4054 11.2619 18.6709C11.2619 18.6709 11.3114 17.3656 11.3113 17.3649C11.3226 17.0641 11.3133 16.7307 11.2299 16.4313C11.1933 16.2877 11.134 16.1509 11.0543 16.0259ZM19.7297 18.0698C19.5692 17.8938 19.3419 17.7184 18.9835 17.5016C18.9317 17.4728 18.8711 17.4342 18.8151 17.4007C18.5166 17.2212 18.1571 17.0323 17.7371 16.8042C17.0927 16.451 16.4451 16.1036 15.7944 15.7622L14.6429 15.1515C14.5832 15.134 14.5226 15.0908 14.4663 15.0637C14.2451 14.9579 14.0105 14.8592 13.7671 14.8139C13.6832 14.7978 13.598 14.7889 13.5126 14.7874C13.4575 14.7868 13.4024 14.7901 13.3478 14.7974C13.1175 14.8332 12.9043 14.9407 12.7386 15.1047C12.573 15.2687 12.4632 15.4807 12.4251 15.7107C12.4076 15.857 12.4129 16.0051 12.441 16.1497C12.4973 16.4562 12.6342 16.7593 12.7756 17.0247L13.3906 18.1773C13.7328 18.8273 14.079 19.4736 14.4341 20.1179C14.6631 20.5381 14.8537 20.8978 15.0323 21.1959C15.0661 21.2519 15.1044 21.3122 15.1334 21.3641C15.3507 21.7225 15.5254 21.9481 15.7024 22.1099C15.817 22.2206 15.9544 22.3049 16.105 22.3569C16.2633 22.4094 16.431 22.4279 16.5969 22.4115C16.6813 22.4015 16.7651 22.387 16.8479 22.368C16.9296 22.346 17.0101 22.32 17.0889 22.2896C17.1741 22.2576 17.2568 22.2194 17.3364 22.1753C17.804 21.9131 18.2349 21.5904 18.6182 21.2156C19.0778 20.7634 19.4841 20.2702 19.8002 19.7056C19.8442 19.6256 19.8821 19.5426 19.914 19.4573C19.9438 19.3783 19.9696 19.2978 19.9913 19.2162C20.0099 19.1332 20.0243 19.0493 20.0342 18.9649C20.05 18.7991 20.0307 18.6318 19.9777 18.4739C19.9256 18.3227 19.8409 18.1847 19.7297 18.0698ZM22.5897 21.8118C22.5902 21.9603 22.552 22.1063 22.4787 22.2354C22.4047 22.3674 22.3007 22.4731 22.1672 22.5526C22.0347 22.6317 21.883 22.6728 21.7287 22.6716C21.5749 22.6727 21.4238 22.632 21.2914 22.5537C21.161 22.4775 21.0531 22.3681 20.9789 22.2366C20.9055 22.1071 20.8673 21.9606 20.8679 21.8118C20.8679 21.6592 20.9059 21.516 20.9822 21.3824C21.0568 21.2506 21.1657 21.1415 21.2972 21.0665C21.4281 20.9901 21.5771 20.9502 21.7287 20.9509C21.8794 20.9503 22.0276 20.9898 22.1581 21.0653C22.2899 21.1398 22.3991 21.2486 22.4741 21.3801C22.5505 21.5111 22.5904 21.6602 22.5897 21.8118ZM22.4695 21.8118C22.4695 21.679 22.4363 21.5558 22.3699 21.442C22.3035 21.3282 22.2135 21.2382 22.0997 21.1718C21.9876 21.1049 21.8593 21.07 21.7287 21.0711C21.5987 21.0703 21.4709 21.1047 21.3589 21.1707C21.2466 21.2357 21.1531 21.3288 21.0876 21.4409C21.0213 21.5532 20.9869 21.6814 20.988 21.8118C20.988 21.9438 21.0212 22.0675 21.0876 22.1828C21.1524 22.2956 21.2461 22.3893 21.3589 22.4541C21.4713 22.519 21.5989 22.553 21.7287 22.5526C21.8587 22.5534 21.9865 22.5189 22.0985 22.453C22.2105 22.3884 22.3036 22.2956 22.3687 22.1839C22.4356 22.0714 22.4704 21.9427 22.4695 21.8118ZM21.8925 21.8702L22.1649 22.3224H21.9727L21.7357 21.9172H21.5811V22.3224H21.4116V21.3024H21.7104C21.8372 21.3024 21.9299 21.3271 21.9887 21.3768C22.0482 21.4264 22.0779 21.502 22.0779 21.6035C22.0788 21.6615 22.0616 21.7183 22.0287 21.766C21.9967 21.8126 21.9512 21.8473 21.8925 21.8702ZM21.8513 21.7294C21.8692 21.7147 21.8835 21.6962 21.8932 21.6751C21.9029 21.6541 21.9078 21.6311 21.9073 21.608C21.9073 21.5507 21.8909 21.5099 21.8582 21.4855C21.8253 21.4604 21.7735 21.4478 21.7025 21.4478H21.5811V21.7763H21.7048C21.7658 21.7763 21.8146 21.7607 21.8513 21.7294Z"
				fill="#FF1A1A"
			/>
		</g>
		<defs>
			<clipPath id="clip0_1_8">
				<rect width="24" height="24" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const WhatsAppIcon = ( props ) => (
	<svg
		width="20"
		height="20"
		viewBox="0 0 20 20"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M0 20L1.40583 14.8642C0.538332 13.3608 0.0824998 11.6567 0.0833332 9.90917C0.0858331 4.44583 4.53166 0 9.99414 0C12.645 0.000833333 15.1333 1.03333 17.005 2.90667C18.8758 4.78 19.9058 7.27 19.905 9.91833C19.9025 15.3825 15.4566 19.8283 9.99414 19.8283C8.33581 19.8275 6.70165 19.4117 5.25415 18.6217L0 20ZM5.49749 16.8275C6.89415 17.6567 8.22748 18.1533 9.99081 18.1542C14.5308 18.1542 18.2291 14.4592 18.2316 9.91667C18.2333 5.365 14.5525 1.675 9.99748 1.67333C5.45415 1.67333 1.75833 5.36833 1.75666 9.91C1.75583 11.7642 2.29916 13.1525 3.21166 14.605L2.37916 17.645L5.49749 16.8275ZM14.9866 12.2742C14.925 12.1708 14.76 12.1092 14.5116 11.985C14.2641 11.8608 13.0466 11.2617 12.8191 11.1792C12.5925 11.0967 12.4275 11.055 12.2616 11.3033C12.0966 11.5508 11.6216 12.1092 11.4775 12.2742C11.3333 12.4392 11.1883 12.46 10.9408 12.3358C10.6933 12.2117 9.89498 11.9508 8.94915 11.1067C8.21331 10.45 7.71582 9.63917 7.57165 9.39083C7.42748 9.14333 7.55665 9.00917 7.67998 8.88583C7.79165 8.775 7.92748 8.59667 8.05165 8.45167C8.17748 8.30833 8.21832 8.205 8.30165 8.03917C8.38415 7.87417 8.34332 7.72917 8.28082 7.605C8.21832 7.48167 7.72332 6.2625 7.51748 5.76667C7.31582 5.28417 7.11165 5.34917 6.95998 5.34167L6.48499 5.33333C6.31999 5.33333 6.05165 5.395 5.82499 5.64333C5.59832 5.89167 4.95832 6.49 4.95832 7.70917C4.95832 8.92833 5.84582 10.1058 5.96915 10.2708C6.09332 10.4358 7.71498 12.9375 10.1991 14.01C10.79 14.265 11.2516 14.4175 11.6108 14.5317C12.2041 14.72 12.7441 14.6933 13.1708 14.63C13.6466 14.5592 14.6358 14.0308 14.8425 13.4525C15.0491 12.8733 15.0491 12.3775 14.9866 12.2742Z"
			fill="#25D366"
		/>
	</svg>
);

export const TelegramIcon = ( props ) => (
	<svg
		width="20"
		height="20"
		viewBox="0 0 20 20"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_15046_51595)">
			<path
				d="M10 20C15.5228 20 20 15.5228 20 10C20 4.47715 15.5228 0 10 0C4.47715 0 0 4.47715 0 10C0 15.5228 4.47715 20 10 20Z"
				fill="url(#paint0_linear_15046_51595)"
			/>
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M4.52587 9.89397C7.44107 8.62386 9.38499 7.78653 10.3576 7.38197C13.1347 6.22688 13.7118 6.02623 14.0879 6.0196C14.1707 6.01814 14.3556 6.03865 14.4754 6.13587C14.5766 6.21796 14.6044 6.32885 14.6177 6.40668C14.6311 6.48451 14.6477 6.66181 14.6345 6.80034C14.484 8.38158 13.8328 12.2188 13.5015 13.9898C13.3613 14.7392 13.0853 14.9905 12.8181 15.0151C12.2374 15.0685 11.7964 14.6313 11.234 14.2626C10.3538 13.6856 9.85662 13.3265 9.0023 12.7635C8.01499 12.1129 8.65502 11.7553 9.21769 11.1709C9.36494 11.018 11.9236 8.69066 11.9731 8.47953C11.9793 8.45313 11.9851 8.35471 11.9266 8.30274C11.8681 8.25077 11.7818 8.26854 11.7195 8.28267C11.6313 8.30271 10.2253 9.23203 7.50149 11.0706C7.10239 11.3447 6.74091 11.4782 6.41703 11.4712C6.05998 11.4635 5.37315 11.2693 4.86257 11.1034C4.23632 10.8998 3.73859 10.7922 3.78193 10.4465C3.8045 10.2664 4.05248 10.0822 4.52587 9.89397Z"
				fill="white"
			/>
		</g>
		<defs>
			<linearGradient
				id="paint0_linear_15046_51595"
				x1="10"
				y1="0"
				x2="10"
				y2="19.8517"
				gradientUnits="userSpaceOnUse"
			>
				<stop stopColor="#2AABEE" />
				<stop offset="1" stopColor="#229ED9" />
			</linearGradient>
			<clipPath id="clip0_15046_51595">
				<rect width="20" height="20" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const BlueSkyIcon = ( props ) => (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" { ...props }>
		<path
			fill="#007BFF"
			d="M111.8 62.2C170.2 105.9 233 194.7 256 242.4c23-47.6 85.8-136.4 144.2-180.2c42.1-31.6 110.3-56 110.3 21.8c0 15.5-8.9 130.5-14.1 149.2C478.2 298 412 314.6 353.1 304.5c102.9 17.5 129.1 75.5 72.5 133.5c-107.4 110.2-154.3-27.6-166.3-62.9l0 0c-1.7-4.9-2.6-7.8-3.3-7.8s-1.6 3-3.3 7.8l0 0c-12 35.3-59 173.1-166.3 62.9c-56.5-58-30.4-116 72.5-133.5C100 314.6 33.8 298 15.7 233.1C10.4 214.4 1.5 99.4 1.5 83.9c0-77.8 68.2-53.4 110.3-21.8z"
		/>
	</svg>
);
