import{Fragment,h}from"@stencil/core";import{__}from"@wordpress/i18n";import{addQueryArgs}from"@wordpress/url";import apiFetch from"../../../../functions/fetch";import{onFirstVisible}from"../../../../functions/lazy";import{formatTaxDisplay}from"../../../../functions/tax";export class ScOrder{constructor(){this.orderId=void 0,this.customerIds=void 0,this.heading=void 0,this.order=void 0,this.purchases=void 0,this.loading=void 0,this.busy=void 0,this.error=void 0}componentDidLoad(){onFirstVisible(this.el,(()=>{this.fetchOrder(),this.fetchDownloads()}))}async fetchOrder(){try{this.loading=!0,await this.getOrder()}catch(t){console.error(this.error),this.error=(null==t?void 0:t.message)||__("Something went wrong","surecart")}finally{this.loading=!1}}async fetchDownloads(){try{this.busy=!0,this.purchases=await apiFetch({path:addQueryArgs("surecart/v1/purchases",{expand:["product","product.downloads","download.media"],order_ids:[this.orderId],customer_ids:this.customerIds,downloadable:!0})})}catch(t){console.error(this.error),this.error=(null==t?void 0:t.message)||__("Something went wrong","surecart")}finally{this.busy=!1}}async getOrder(){this.order=await apiFetch({path:addQueryArgs(`surecart/v1/orders/${this.orderId}`,{expand:["checkout","checkout.line_items","line_item.price","line_item.fees","line_item.variant","variant.image","price.product","checkout.manual_payment_method","checkout.payment_method","checkout.selected_shipping_choice","shipping_choice.shipping_method","payment_method.card","payment_method.payment_instrument","payment_method.paypal_account","payment_method.bank_account","checkout.discount","discount.promotion","checkout.charge"]})})}renderLoading(){return h("sc-flex",{flexDirection:"column",style:{gap:"1em"}},h("sc-skeleton",{style:{width:"20%",display:"inline-block"}}),h("sc-skeleton",{style:{width:"60%",display:"inline-block"}}),h("sc-skeleton",{style:{width:"40%",display:"inline-block"}}))}renderEmpty(){return h("sc-empty",{icon:"shopping-bag"},__("Order not found.","surecart"))}renderContent(){var t,e,i,o,s,l,n,r;if(this.loading)return this.renderLoading();if(!(null===(t=this.order)||void 0===t?void 0:t.id))return this.renderEmpty();const a=null===(e=this.order)||void 0===e?void 0:e.checkout,d=null===(i=null==a?void 0:a.selected_shipping_choice)||void 0===i?void 0:i.shipping_method,c=null==d?void 0:d.name;return h(Fragment,null,((null===(o=null==a?void 0:a.line_items)||void 0===o?void 0:o.data)||[]).map((t=>{var e,i,o,s,l,n,r;return h("sc-product-line-item",{key:t.id,image:null==t?void 0:t.image,name:null===(i=null===(e=null==t?void 0:t.price)||void 0===e?void 0:e.product)||void 0===i?void 0:i.name,price:null===(o=null==t?void 0:t.price)||void 0===o?void 0:o.name,variant:null==t?void 0:t.variant_display_options,editable:!1,removable:!1,quantity:t.quantity,note:null==t?void 0:t.display_note,amount:t.subtotal_display_amount,trial:null===(s=null==t?void 0:t.price)||void 0===s?void 0:s.trial_text,interval:`${null===(l=null==t?void 0:t.price)||void 0===l?void 0:l.short_interval_text} ${null===(n=null==t?void 0:t.price)||void 0===n?void 0:n.short_interval_count_text}`,scratch:null==t?void 0:t.scratch_display_amount,purchasableStatus:null==t?void 0:t.purchasable_status_display,fees:null===(r=null==t?void 0:t.fees)||void 0===r?void 0:r.data})})),(null==a?void 0:a.subtotal_amount)!==(null==a?void 0:a.total_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Subtotal","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.subtotal_display_amount)),!!(null==a?void 0:a.trial_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Trial","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.trial_display_amount)),!!(null==a?void 0:a.discounts)&&h("sc-line-item",null,h("span",{slot:"description"},__("Discounts","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.discounts_display)),!!(null===(l=null===(s=null==a?void 0:a.discount)||void 0===s?void 0:s.promotion)||void 0===l?void 0:l.code)&&h("sc-line-item",null,h("span",{slot:"description"},__("Discount","surecart"),h("br",null),h("sc-tag",{type:"success"},__("Coupon:","surecart")," ",null===(r=null===(n=null==a?void 0:a.discount)||void 0===n?void 0:n.promotion)||void 0===r?void 0:r.code)),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.discounts_display_amount)),!!(null==a?void 0:a.shipping_amount)&&h("sc-line-item",null,h("span",{slot:"description"},`${__("Shipping","surecart")} ${c?`(${c})`:""}`),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.shipping_display_amount)),!!(null==a?void 0:a.tax_amount)&&h("sc-line-item",null,h("span",{slot:"description"},`${formatTaxDisplay(null==a?void 0:a.tax_label,"estimated"===(null==a?void 0:a.tax_status))} (${null==a?void 0:a.tax_percent}%)`),h("span",{slot:"price"},null==a?void 0:a.tax_display_amount),!!(null==a?void 0:a.tax_inclusive_amount)&&h("span",{slot:"price-description"},`(${__("included","surecart")})`)),h("sc-divider",{style:{"--spacing":"var(--sc-spacing-x-small)"}}),h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Total","surecart")),h("span",{slot:"price"},null==a?void 0:a.total_display_amount),h("span",{slot:"currency"},null==a?void 0:a.currency)),!!(null==a?void 0:a.proration_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Proration","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.proration_display_amount)),!!(null==a?void 0:a.applied_balance_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Applied Balance","surecart")),h("span",{style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},slot:"price"},null==a?void 0:a.applied_balance_display_amount)),!!(null==a?void 0:a.credited_balance_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Credited Balance","surecart")),h("span",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"}},null==a?void 0:a.credited_balance_display_amount)),(null==a?void 0:a.amount_due)!==(null==a?void 0:a.total_amount)&&h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Amount Due","surecart")),h("span",{slot:"price"},null==a?void 0:a.amount_due_display_amount),h("span",{slot:"currency"},null==a?void 0:a.currency)),h("sc-divider",{style:{"--spacing":"var(--sc-spacing-x-small)"}}),!!(null==a?void 0:a.paid_amount)&&h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Paid","surecart")),h("span",{slot:"price"},null==a?void 0:a.paid_display_amount),h("span",{slot:"currency"},null==a?void 0:a.currency)),!!(null==a?void 0:a.refunded_amount)&&h(Fragment,null,h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"description"},__("Refunded","surecart")),h("span",{slot:"price"},null==a?void 0:a.refunded_display_amount)),h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Net Payment","surecart")),h("span",{slot:"price"},null==a?void 0:a.net_paid_display_amount))),(null==a?void 0:a.tax_reverse_charged_amount)>0&&h("sc-line-item",null,h("span",{slot:"description"},__("*Tax to be paid on reverse charge basis","surecart"))))}render(){var t,e,i,o,s,l,n;const r=null===(t=null==this?void 0:this.order)||void 0===t?void 0:t.checkout,a=null==r?void 0:r.manual_payment_method;return h("sc-spacing",{key:"1ed0387135a58c11a0f7bc676cea482679b5ff50",style:{"--spacing":"var(--sc-spacing-large)"}},h("sc-dashboard-module",{key:"01a16a43371173828c54307d927fa2a7421218b1",error:this.error},h("span",{key:"b013ff814cfc746209d4fadc8c28be5fba33f0d6",slot:"heading"},this.loading?h("sc-skeleton",{style:{width:"120px"}}):`#${null===(e=null==this?void 0:this.order)||void 0===e?void 0:e.number}`),!this.loading&&!(null==r?void 0:r.live_mode)&&h("sc-tag",{key:"a53f43b742ceb46ebf7f043a60657da3c8abd972",type:"warning",slot:"end"},__("Test Mode","surecart")),!!(null==a?void 0:a.name)&&!!(null==a?void 0:a.instructions)&&h("sc-order-manual-instructions",{key:"e076692426ae4b1a53cd9f5172cd77995bf35ad7",manualPaymentTitle:null==a?void 0:a.name,manualPaymentInstructions:null==a?void 0:a.instructions}),h("sc-card",{key:"814a42fd92f2325627258b5eb64e5d1225800577","no-padding":!this.loading},this.loading?this.renderLoading():h(Fragment,null,h("sc-stacked-list",null,h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Order Status","surecart")),h("sc-order-status-badge",{status:null===(i=null==this?void 0:this.order)||void 0===i?void 0:i.status})),h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Date","surecart")),h("span",null,null===(o=this.order)||void 0===o?void 0:o.created_at_date)),h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Payment Method","surecart")),h("sc-payment-method",{paymentMethod:null==r?void 0:r.payment_method})),h("div",{class:"order__row"},this.renderContent()))))),(null===(s=this.order)||void 0===s?void 0:s.statement_url)&&h("sc-button",{key:"8498333f4edcd8805d9ba7e12aa7328b9ed336f7",type:"primary",href:null===(l=this.order)||void 0===l?void 0:l.statement_url,target:"_blank"},h("sc-icon",{key:"9101a53a87dc60085477b5398110c5822931b25c",name:"inbox",slot:"prefix"}),__("Download Receipt/Invoice","surecart")),!!(null===(n=this.purchases)||void 0===n?void 0:n.length)&&h("sc-purchase-downloads-list",{key:"cdc6e99d9d0f5d788ab78984aeecb3f8fdf71c8e",heading:__("Downloads","surecart"),purchases:this.purchases}))}static get is(){return"sc-order"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["sc-order.scss"]}}static get styleUrls(){return{$:["sc-order.css"]}}static get properties(){return{orderId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"order-id",reflect:!1},customerIds:{type:"unknown",mutable:!1,complexType:{original:"string[]",resolved:"string[]",references:{}},required:!1,optional:!1,docs:{tags:[],text:""}},heading:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"heading",reflect:!1}}}static get states(){return{order:{},purchases:{},loading:{},busy:{},error:{}}}static get elementRef(){return"el"}}