<?php

namespace Twine\forms\strategies\display;

/**
 *
 * Class SelectDisplay
 *
 * Extends the SelectDisplay to also enqueue the select2.js and js to
 * convert this input into a select2
 *
 * @package             Event Espresso
 * @subpackage  core
 * @author              Mike Nelson
 *
 *
 */
class Select2Display extends SelectDisplay
{

    /**
     * Arguments that will be passed into the select2 javascript constructor
     * @var array
     */
    protected $select2_js_args = array();

    /**
     *
     * @param array $select2_js_args pass in the EXACT array of JS arguments you want
     * to pass into the select2 js/html input. See https://select2.github.io
     */
    public function __construct($select2_js_args = array())
    {
        $this->select2_js_args = $select2_js_args;
        parent::__construct();
    }

    /**
     * Enqueues the select2 initializing js (which depends on the select2 js) and
     * the select2 css
     */
    public function enqueueJs()
    {
        // need to first deregister the select2 script in case some other plugin **cough cough Toolset Types cough**
        // is carelessly registering an older version of Select2 on admin pages that don't even belong to them
        wp_deregister_script('select2');
        wp_deregister_style('select2');
        wp_register_script(
            'select2',
            TWINE_SCRIPTS_URL . 'select2.min.js',
            array(),
            '4.0.2',
            true
        );
        wp_register_style(
            'select2',
            TWINE_STYLES_URL . 'select2.min.css',
            array(),
            '4.0.2',
            'all'
        );
        wp_enqueue_script(
            'form_section_select2_init',
            TWINE_SCRIPTS_URL . 'form_section_select2_init.js',
            array( 'select2' ),
            '1.0.0',
            true
        );
        wp_enqueue_style(
            'select2',
            TWINE_STYLES_URL . 'select2.min.css',
            array(),
            '4.0.2',
            'all'
        );
    }

    /**
     * Gets the javascript args which will be localized and passed into the select2 js/html input
     * @return array
     */
    public function getJsArgs()
    {
        return $this->select2_js_args;
    }

    /**
     * Sets the exact js args which will be passed into the select2 js/html input
     * @param array $js_args
     */
    public function setJsArgs($js_args)
    {
        $this->select2_js_args = $js_args;
    }

    /**
     * Adds select2 data for localization
     * @param array $other_js_data
     * @return array
     */
    public function getOtherJsData($other_js_data = array())
    {
        $other_js_data = parent::getOtherJsData($other_js_data);
        if (! isset($other_js_data['select2s'])) {
            $other_js_data['select2s'] = array();
        }
        $other_js_data['select2s'][ $this->input->htmlId() ] = $this->getJsArgs();
        return $other_js_data;
    }

    /**
     * Overrides standard attributes array to add the CSS class "twine-select2"
     * @return array
     */
    protected function standardAttributesArray()
    {
        $standard_attributes = parent::standardAttributesArray();
        $standard_attributes['class'] .= ' twine-select2';
        return $standard_attributes;
    }
}
