<?php

namespace PrintMyBlog\system;

use Twine\system\Context as BaseContext;

/**
 * Class Context
 *
 * Stores instances of the classes used by Print My Blog for dependency injection.
 *
 * @package        Print My Blog
 * @author         Mike Nelson
 * @since          $VID:$
 *
 */
class Context extends BaseContext
{

    /**
     * @var Context
     */
    protected static $instance;

    /**
     * Sets the dependencies in the context. Keys are classnames, values are an array
     * whose keys are classnames dependend on, and values are either self::USE_NEW or self::REUSE.
     * Classes
     */
    protected function setDependencies()
    {
        $this->deps = [
            'PrintMyBlog\system\Activation' => [
                'Twine\system\RequestType' => self::REUSE,
                'PrintMyBlog\db\TableManager' => self::REUSE,
                'PrintMyBlog\system\Capabilities' => self::REUSE,
                'PrintMyBlog\services\DesignRegistry' => self::REUSE,
                'PrintMyBlog\domain\DefaultProjectContents' => self::REUSE,
                'PrintMyBlog\db\migrations\MigrationManager' => self::REUSE,
                'Twine\system\VersionHistory' => self::REUSE,
            ],
            'Twine\system\RequestType'      => [
                'Twine\system\VersionHistory' => self::REUSE,
                'pmb_activation',
            ],
            'Twine\system\VersionHistory'   => [
                PMB_VERSION,
                'pmb_previous_version',
                'pmb_version_history',
            ],
            'PrintMyBlog\controllers\Admin' => [
                'PrintMyBlog\db\PostFetcher'              => self::REUSE,
                'PrintMyBlog\orm\managers\ProjectSectionManager' => self::REUSE,
                'PrintMyBlog\orm\managers\ProjectManager' => self::REUSE,
                'PrintMyBlog\services\FileFormatRegistry'   => self::REUSE,
                'PrintMyBlog\orm\managers\DesignManager' => self::REUSE,
                'PrintMyBlog\db\TableManager' => self::REUSE,
                'PrintMyBlog\services\SvgDoer' => self::REUSE,
                'Twine\services\notifications\OneTimeNotificationManager' => self::REUSE,
                'PrintMyBlog\services\DebugInfo' => self::REUSE,
                'PrintMyBlog\services\PmbCentral' => self::REUSE,
                'Twine\orm\managers\PostWrapperManager' => self::REUSE,
                'PrintMyBlog\services\ExternalResourceCache' => self::REUSE,
                'PrintMyBlog\services\config\Config' => self::REUSE,
            ],
            'PrintMyBlog\services\PersistentNotices' => [
                'mnelson4\AdminNotices\Notices' => self::REUSE,
                'PrintMyBlog\domain\DefaultPersistentNotices' => self::REUSE,
            ],
            'PrintMyBlog\controllers\Ajax'  => [
                'PrintMyBlog\orm\managers\ProjectManager' => self::REUSE,
                'PrintMyBlog\services\FileFormatRegistry' => self::REUSE,
                'PrintMyBlog\db\PostFetcher' => self::REUSE,
                'PrintMyBlog\services\PmbCentral' => self::REUSE,
                'Twine\orm\managers\PostWrapperManager' => self::REUSE,
                'PrintMyBlog\services\ExternalResourceCache' => self::REUSE,
            ],
            'PrintMyBlog\orm\entities\Project'          => [
                'PrintMyBlog\orm\managers\ProjectSectionManager' => self::REUSE,
                'PrintMyBlog\services\FileFormatRegistry'  => self::REUSE,
                'PrintMyBlog\orm\managers\DesignManager' => self::REUSE,
                'PrintMyBlog\services\config\Config' => self::REUSE,
                'PrintMyBlog\factories\ProjectGenerationFactory' => self::REUSE,
                'PrintMyBlog\services\SectionTemplateRegistry' => self::REUSE,
            ],
            'PrintMyBlog\services\DesignRegistry' => [
                'PrintMyBlog\orm\managers\DesignManager' => self::REUSE,
                'PrintMyBlog\services\DesignTemplateRegistry' => self::REUSE,
            ],
            'PrintMyBlog\orm\entities\Design' => [
                'PrintMyBlog\services\DesignTemplateRegistry' => self::REUSE,
            ],
            'PrintMyBlog\entities\DesignTemplate' => [
                'PrintMyBlog\services\FileFormatRegistry' => self::REUSE,
                'PrintMyBlog\orm\managers\DesignManager' => self::REUSE,
                'PrintMyBlog\services\SectionTemplateRegistry' => self::REUSE,
            ],
            'PrintMyBlog\services\config\Config' => [
                'PrintMyBlog\services\FileFormatRegistry' => self::REUSE,
                'PrintMyBLog\orm\managers\DesignManager' => self::REUSE,
            ],
            'PrintMyBlog\entities\ProjectGeneration' => [
                'PrintMyBlog\orm\managers\ProjectSectionManager' => self::REUSE,
                'PrintMyBlog\factories\ProjectFileGeneratorFactory' => self::REUSE,
            ],
            'PrintMyBlog\services\generators\PdfGenerator' => [
                'PrintMyBlog\db\PostFetcher' => self::REUSE,
                'PrintMyBlog\compatibility\DetectAndActivate' => self::REUSE,
                'PrintMyBlog\services\ExternalResourceCache' => self::REUSE,
            ],
            'PrintMyBlog\services\generators\EpubGenerator' => [
                'PrintMyBlog\db\PostFetcher' => self::REUSE,
                'PrintMyBlog\compatibility\DetectAndActivate' => self::REUSE,
                'PrintMyBlog\services\ExternalResourceCache' => self::REUSE,
            ],
            'PrintMyBlog\services\generators\WordGenerator' => [
                'PrintMyBlog\db\PostFetcher' => self::REUSE,
                'PrintMyBlog\compatibility\DetectAndActivate' => self::REUSE,
                'PrintMyBlog\services\ExternalResourceCache' => self::REUSE,
            ],
            'PrintMyBlog\services\FileFormatRegistry' => [
                'PrintMyBlog\factories\FileFormatFactory' => self::REUSE,
            ],
            'PrintMyBlog\entities\FileFormat' => [
                'PrintMyBlog\services\DesignTemplateRegistry' => self::REUSE,
            ],
            'PrintMyBlog\db\PostFetcher' => [
                'PrintMyBlog\system\CustomPostTypes' => self::REUSE,
            ],
            'PrintMyBlog\system\CustomPostTypes' => [
                'PrintMyBlog\services\SvgDoer' => self::REUSE,
            ],
            'PrintMyBlog\services\DebugInfo' => [
                'PrintMyBlog\orm\managers\ProjectManager' => self::REUSE,
                'PrintMyBlog\orm\managers\DesignManager' => self::REUSE,
            ],
            'PrintMyBlog\services\SectionTemplateRegistry' => [
                'PrintMyBlog\services\DesignTemplateRegistry' => self::REUSE,
            ],
            'PrintMyBlog\db\migrations\MigrationManager' => [
                'Twine\system\RequestType' => self::REUSE,
                'Twine\system\VersionHistory' => self::REUSE,
                'pmb_',
            ],
            'PrintMyBlog\domain\PrintButtons' => [
                'PrintMyBlog\domain\FrontendPrintSettings' => self::REUSE,
            ],
            'PrintMyBlog\domain\FrontendPrintSettings' => [
                'PrintMyBlog\domain\PrintOptions' => self::REUSE,
            ],
            'PrintMyBlog\domain\PrintPageUrlGenerator' => [
                'PrintMyBlog\domain\FrontendPrintSettings' => self::REUSE,
            ],
            'PrintMyBlog\system\Capabilities' => [
                'PrintMyBlog\system\CustomPostTypes' => self::REUSE,
            ],
            'PrintMyBlog\compatibility\plugins\Wpml' => [
                'PrintMyBlog\orm\managers\ProjectManager' => self::REUSE,
                'PrintMyBlog\orm\managers\DesignManager' => self::REUSE,
                'PrintMyBlog\system\CustomPostTypes' => self::REUSE,
            ],
            'PrintMyBlog\domain\DefaultDesignTemplates' => [
                'PrintMyBlog\helpers\ImageHelper' => self::REUSE,
            ],
            'PrintMyBlog\services\ExternalResourceCache' => [
                'PrintMyBlog\orm\managers\ExternalResourceManager' => self::REUSE,
            ],
            'PrintMyBlog\controllers\Frontend' => [
                'PrintMyBlog\orm\managers\ProjectManager' => self::REUSE,
                'PrintMyBlog\services\FileFormatRegistry'   => self::REUSE,
                'PrintMyBlog\services\PmbCentral' => self::REUSE,
            ],
            'PrintMyBlog\system\FileUploads' => [],
        ];
    }
}
