<?php

namespace PrintMyBlog\compatibility\plugins;

use Twine\compatibility\CompatibilityBase;
use TablePress as TablePressInit;

/**
 * Class TablePress
 * @package PrintMyBlog\compatibility\plugins
 */
class TablePress extends CompatibilityBase
{

    /**
     * Get TablePress to register its shortcodes on our special AJAX request too.
     * See https://wordpress.org/support/topic/short-code-displaying-when-call-post-data-through-ajax/
     */
    public function setRenderingHooks()
    {
        $zero = class_exists('TablePress');
        $a = property_exists('TablePress', 'controller');
        $b = method_exists('TablePress', 'load_controller');
        if (
            defined('DOING_AJAX') && DOING_AJAX
            && class_exists('TablePress')
            && property_exists('TablePress', 'controller')
            && method_exists('TablePress', 'load_controller')
        ) {
            TablePressInit::$controller = TablePressInit::load_controller('frontend');
            if (method_exists(TablePressInit::$controller, 'init_shortcodes')) {
                TablePressInit::$controller->init_shortcodes();
                add_filter('tablepress_table_js_options', [$this, 'optimizeTablesForPmb']);
            }
        }
        parent::setRenderingHooks(); // TODO: Change the autogenerated stub
    }

    /**
     * Filters TablePress' options to remove interactive elements like pagination, sorting, and searching.
     * See \TablePress_Frontend_Controller::shortcode_table()
     * @param array $original_options
     * @return array
     */
    public function optimizeTablesForPmb($original_options)
    {
        $original_options['datatables_paginate'] = false;
        $original_options['datatables_sort'] = false;
        $original_options['datatables_filter'] = false;
        return $original_options;
    }
}
